/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.register;

import com.charles445.simpledifficulty.api.SDBlocks;
import com.charles445.simpledifficulty.api.SDFluids;
import com.charles445.simpledifficulty.api.SDItems;
import com.charles445.simpledifficulty.block.IBlockStateIgnore;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="simpledifficulty")
public class RegisterClientModels {
    public static final RegisterClientModels instance = new RegisterClientModels();

    @SubscribeEvent
    public static void onModelRegistryEvent(ModelRegistryEvent event) {
        for (String key : SDFluids.fluidBlocks.keySet()) {
            instance.registerFluidModel(SDFluids.fluidBlocks.get(key));
        }
        for (String key : SDItems.items.keySet()) {
            instance.registerItemModel(SDItems.items.get(key));
        }
        for (String key : SDBlocks.blocks.keySet()) {
            instance.tweakBlockModelState(SDBlocks.blocks.get(key));
            instance.registerBlockItemModel(Item.func_150898_a((Block)SDBlocks.blocks.get(key)), SDBlocks.blocks.get(key).func_149739_a());
        }
    }

    private void tweakBlockModelState(Block block) {
        if (block instanceof IBlockStateIgnore) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(((IBlockStateIgnore)block).getIgnoredProperties()).func_178441_a());
        }
    }

    private void registerBlockItemModel(Item item, String blockUnloc) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(blockUnloc.substring(5), "inventory"));
    }

    private void registerFluidModel(BlockFluidBase block) {
        final ModelResourceLocation model = new ModelResourceLocation("simpledifficulty:fluids", block.getFluid().getName());
        Item item = Item.func_150898_a((Block)block);
        ModelLoader.setCustomMeshDefinition((Item)item, meshDefinition -> model);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return model;
            }
        });
    }

    private void registerItemModel(Item item) {
        this.registerSingleItemModel(item, item.getRegistryName().toString());
        if (item.func_77614_k()) {
            item.func_185043_a(new ResourceLocation("simpledifficulty", "type"), (IItemPropertyGetter)new MetadataPropertyGetter());
        }
    }

    private void registerSingleItemModel(Item item, String path) {
        final ModelResourceLocation fullModelLocation = new ModelResourceLocation(path, "inventory");
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return fullModelLocation;
            }
        });
    }

    public class MetadataPropertyGetter
    implements IItemPropertyGetter {
        public float func_185085_a(ItemStack stack, World world, EntityLivingBase entity) {
            return stack.func_77960_j();
        }
    }
}

